#ifndef _LIKEONPC
    #define _LIKEONPC
    
    
    #ifdef SAVE_SCREEN
        #undef SAVE_SCREEN
    #endif
    #ifndef RETURN_VALUE
        #define RETURN_VALUE
    #endif
    
    
    #include <tigcclib.h>
    #include <errno.h>
    
    
    
    
    #define _ARGC_MAX_               32
    #define _ARGV_MAXLENGTH_         256
    #define _ARGV_BUFFER_MAXLENGTH_  (_ARGV_MAXLENGTH_ + _ARGC_MAX_)
    #define _GETS_MAXLENGTH_         256
    
    
    #undef main
    #undef getchar
    #undef getch
    #undef gets
    #undef getsn
    #undef scanf
    #undef puts
    #undef free
    #undef exit
    
    
    #define main                        m_a_i_n
    #define getchar()                   (_internal_getsn_(NULL, -1)[0])
    #define getch()                     (getchar())
    #define gets(buff)                  (_internal_getsn_((buff), -1))
    #define getsn(buff, n)              (_internal_getsn_((buff), (n)))
#ifndef __GTC__
    #define scanf(format, pointers...)  (sscanf(_internal_getsn_(NULL, -1), (format), pointers))
#endif
    #define puts(string)                (printf("%s\n", (string)))
    #define free(mem)                   ({if ((mem) != NULL) HeapFreePtr(mem);})
    #define exit(errno)                 ({_just_before_program_exit_(errno); __exit();})
    
    
    
    
    extern int main();
    extern void push_shortint(short value);      // si le compilateur ne trouve pas cette interface dans les headers...
    
    
    
    
    static int   _scrW_,               // largeur de l'écran de la machine
                 _scrH_;               // hauteur de l'écran de la machine
    
    static int   _KEY_LEFT_,           // code de la touche <-
                 _KEY_RIGHT_;          // code de la touche ->
               
    static int   _user_cursX_,         // abscisse courante du curseur de saisie
                 _user_cursY_,         // ordonnée courante du curseur de saisie
                 _sys_initial_cursX_,  // abscisse initiale du curseur système
                 _sys_initial_cursY_;  // ordonnée initiale du curseur système
    
    
    
    
    
    
    
    
    static inline int _just_after_program_entrance_(void) {
        // renseignement des dimensions de l'écran
        _scrW_= (TI92PLUS | V200) ? 240 : 160;
        _scrH_= (TI92PLUS | V200) ? 128 : 100;
        // renseignement des touches de direction
        if (_scrW_ == 160) {   // TI 89
            _KEY_LEFT_ = 338;
            _KEY_RIGHT_= 344;
        } else {               // TI 92+ ou V200
            _KEY_LEFT_ = 337;
            _KEY_RIGHT_= 340;
        }
        
        return (TRUE);
    }
    
    
    
    
    void _just_before_program_exit_(int errno) {
        WINDOW     w;
        short     *line;
        short      i;
        
        
        // on provoque le rafraichissement de l'écran Home
        WinOpen(&w, MakeWinRect(0, 0, 239, 127), WF_NOBORDER);
        WinActivate(&w);
        WinClose(&w);
        // on provoque le rafraichissement de la barre de statut
        ST_helpMsg("");
        ST_eraseHelp();
        // on redessine la séparation entre le prompt et la barre de statut
        line= LCD_MEM + 30*(_scrH_-7);
        for(i=30/2; i>0; i--) {
            *line++= -1;
        }
        // on envoit la valeur de retour sur Home
        push_shortint(errno);
        // on vide la queue clavier
        GKeyFlush();
    }
    
    
    
    
    static inline int _parse_expression_stack_arguments_(int *argc, char *argv[], char argv_buffer[]) {
        char  parsed_numbers[16];  // buffer temporaire pour les scalaires
        ESI   exp_stack;           // pile d'expressions
        int   buffer_length;       // nombre de caractères écrits dans argv_buffer
        int   end_of_args;         // booléen indiquant que tous les paramètres ont été parsés
        int   own_argc;            // argc local qui sera retourné dans *argc
        int   error_code;          // valeur a retourner
        
        
        
        
        InitArgPtr(exp_stack);
        buffer_length= 0;
        own_argc= 0;
        end_of_args= FALSE;  // vaudra TRUE lorsque tous les arguents seront égrainés
        error_code= 0;
        
        // écriture de l'argument zéro, qui doit être soit une chaine nulle, soit le nom du programme. En l'occurence, c'est une chaine nulle.
        argv[own_argc]= &argv_buffer[buffer_length];
        argv[own_argc][0]= '\0';
        buffer_length++;
        own_argc++;
        
        while (!end_of_args && error_code == 0) {
            argv[own_argc]= &argv_buffer[buffer_length];
            
            switch (GetArgType(exp_stack)) {
                case STR_TAG     : {
                                       const char *strin=  GetStrnArg(exp_stack);
                                       char       *strout= argv[own_argc];
                                       int         stop=   FALSE;
                                       
                                       while (!stop) {
                                           if (*strin == ' ' || *strin == 0) {
                                               if (*strin == 0)  stop= TRUE;
                                               if (strout != argv[own_argc]) {  // si on vient de copier un argument
                                                   if (own_argc+1 >= _ARGC_MAX_) {
                                                       // trop d'arguments
                                                       error_code= E2BIG;
                                                       break;
                                                   }
                                                   *strout= 0; buffer_length++;  // zéro terminal
                                                   own_argc++;
                                                   argv[own_argc]= &argv_buffer[buffer_length];
                                                   strout= argv[own_argc];
                                               }
                                           } else {
                                               if (*strin == '\\')  strin++;
                                               *strout++= *strin;
                                               buffer_length++;
                                               if (buffer_length >= _ARGV_BUFFER_MAXLENGTH_) {
                                                   // trop d'arguments
                                                   error_code= E2BIG;
                                                   break;
                                               }
                                           }
                                           if (*strin != 0)  strin++;
                                       }
                                   }
                                   break;
                                   
                case POSINT_TAG  : buffer_length+= sprintf(parsed_numbers, "%lu", GetIntArg(exp_stack)) + 1;
                                   if (buffer_length > _ARGV_BUFFER_MAXLENGTH_ || own_argc+1 >= _ARGC_MAX_) {
                                       // trop d'arguments
                                       error_code= E2BIG;
                                   } else {
                                       strcpy(argv[own_argc], parsed_numbers);
                                       own_argc++;
                                   }
                                   break;
                                   
                case NEGINT_TAG  : buffer_length+= sprintf(parsed_numbers, "-%lu", GetIntArg(exp_stack)) + 1;
                                   if (buffer_length > _ARGV_BUFFER_MAXLENGTH_ || own_argc+1 >= _ARGC_MAX_) {
                                       // trop d'arguments
                                       error_code= E2BIG;
                                   } else {
                                       strcpy(argv[own_argc], parsed_numbers);
                                       own_argc++;
                                   }
                                   break;
#ifndef __GTC__
                case FLOAT_TAG   : buffer_length+= sprintf(parsed_numbers, "%f", GetFloatArg(exp_stack)) + 1;
                                   if (buffer_length > _ARGV_BUFFER_MAXLENGTH_ || own_argc+1 >= _ARGC_MAX_) {
                                       // trop d'arguments
                                       error_code= E2BIG;
                                   } else {
                                       strcpy(argv[own_argc], parsed_numbers);
                                       own_argc++;
                                   }
                                   break;
#endif
                case END_TAG     : end_of_args= TRUE;
                                   break;
                                   
                default          : error_code= EINVAL;
                                   break;
            }
            if (own_argc < _ARGC_MAX_) argv[own_argc]= NULL;  // conformément à la norme, l'argument qui suit le dernier pointe vers NULL
        }
        
        *argc= own_argc;
        return (error_code);
    }
    
    
    
    
    void _main(void) {
        int   argc;                                  // nombre d'arguments égrainés
        char *argv[_ARGC_MAX_];                      // arguments égrainés
        char  argv_buffer[_ARGV_BUFFER_MAXLENGTH_];  // +_ARGC_MAX_ car on doit aussi stocker les zéros terminaux
        int   error_code;                            // code d'erreur du programme
        
        
        
        
        if (!_just_after_program_entrance_()) {
            error_code= ENOMEM;
        } else {
            error_code= _parse_expression_stack_arguments_(&argc, argv, argv_buffer);
        }
        
        // vidage de la pile d'arguments (bout de code provenant de la documentation de TIGCC)
        while (GetArgType(top_estack) != END_TAG)
           top_estack= next_expression_index(top_estack);
        top_estack--;
        
        // exécution du programme utilisateur si tout s'est bien passé jusqu'ici
        if (error_code == 0) {
            clrscr();
            FontSetSys(F_6x8);
            error_code= main(argc, argv);
        }
        
        _just_before_program_exit_(error_code);
    }
    
    
    
    
    
    
    
    
    static void _get_system_cursor_coordinates_(int *x, int*y) {
        SCR_STATE scr_state;
        
        
        SaveScrState(&scr_state);
        *x= scr_state.CurX;
        *y= scr_state.CurY;
    }
    
    
    
    
    static inline void _set_system_cursor_coordinates_(int x, int y) {
        MoveTo(x, y);
    }
    
    
    
    
    static inline void _set_user_cursor_coordinates_(int x, int y) {
        _user_cursX_= x;
        _user_cursY_= y;
    }
    
    
    
    
    static void _draw_rectangle_as_cursor_(int x, int y, short mode) {
        SCR_RECT cursor,
                 screen;
        
        
        
        
        cursor.xy.x0= x;
        cursor.xy.y0= y;
        switch (FontGetSys()) {
            case F_4x6  : cursor.xy.x1= x + 4;
                          cursor.xy.y1= y + 6;
                          break;
            case F_6x8  : cursor.xy.x1= x + 6;
                          cursor.xy.y1= y + 8;
                          break;
            case F_8x10 : cursor.xy.x1= x + 8;
                          cursor.xy.y1= y + 10;
                          break;
        }
        
        screen.xy.x0= 0;
        screen.xy.y0= 0;
        screen.xy.x1= _scrW_ - 1;
        screen.xy.y1= _scrH_ - 1;
        
        ScrRectFill(&cursor, &screen, mode);
    }
    
    
    
    
    static inline void _put_user_cursor_() {
        _draw_rectangle_as_cursor_(_user_cursX_, _user_cursY_, A_XOR);
    }
    
    
    
    
    static inline void _erase_user_cursor_() {
        _draw_rectangle_as_cursor_(_user_cursX_, _user_cursY_, A_REVERSE);
    }
    
    
    
    
    static inline void _initialize_editor_() {
        _get_system_cursor_coordinates_(&_sys_initial_cursX_, &_sys_initial_cursY_);
        _user_cursX_= _sys_initial_cursX_;
        _user_cursY_= _sys_initial_cursY_;
    }
    
    
    
    
    static void _refresh_editor_(const char *entry, int show_cursor, int cursor_index) {
        int  x,
             y;
        
        
        
        
        _set_system_cursor_coordinates_(_sys_initial_cursX_, _sys_initial_cursY_);
        _erase_user_cursor_();
        
        while (cursor_index-- > 0) {
            putchar(*entry++);
        }
        
        _get_system_cursor_coordinates_(&x, &y);
        
        printf("%s%s", entry, (FontGetSys()==F_4x6)?"    ":" ");
        
        
        if (show_cursor) {
            _set_user_cursor_coordinates_(x, y);
            _put_user_cursor_();
        }
    }
    
    
    
    
    char *_internal_getsn_(char *user_buffer, int size_without_0) {
        static char  own_buffer[_GETS_MAXLENGTH_+1];
        char        *s_entry;
        
        int          c_entry;
        
        int          length,
                     max_length,
                     cur_pos;
        
        
        
        
        _initialize_editor_();
        length = 0;
        cur_pos= 0;
        
        max_length= (size_without_0 < 0) ? _GETS_MAXLENGTH_ : size_without_0;
        if (user_buffer == NULL) {
            s_entry= own_buffer;
            if (max_length > _GETS_MAXLENGTH_) max_length= _GETS_MAXLENGTH_;
        } else {
            s_entry= user_buffer;
        }
        
        do {
            // zéro terminal
            s_entry[length]= 0;
            
            _refresh_editor_(s_entry, TRUE, cur_pos);
            
            c_entry= ngetchx();
            
            // si le caractère entré est alphanumérique et si le buffer n'est pas rempli
            if (c_entry >= 32 && c_entry <= 255 && length < max_length) {
                memmove(&s_entry[cur_pos+1], &s_entry[cur_pos], length-cur_pos);
                s_entry[cur_pos]= c_entry;
                cur_pos++;
                length++;
            } else {
                if (c_entry == KEY_BACKSPACE   &&    cur_pos > 0) {
                        cur_pos--;
                        length--;
                        memmove(&s_entry[cur_pos], &s_entry[cur_pos+1], length-cur_pos);
                }
                else
                if (c_entry == KEY_CLEAR       &&    cur_pos < length) {
                        length--;
                        memmove(&s_entry[cur_pos], &s_entry[cur_pos+1], length-cur_pos);
                }
                else
                if (c_entry == _KEY_LEFT_      &&    cur_pos > 0) {
                        cur_pos--;
                }
                else
                if (c_entry == _KEY_RIGHT_     &&    cur_pos < length) {
                        cur_pos++;
                }
            }
        } while (c_entry != KEY_ENTER);
        
        _refresh_editor_(s_entry, FALSE, cur_pos);
        
        printf("\n");
        return (s_entry);
    }




#endif
